/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.RandomizableParallelIteratedSingleClassifierEnhancer;
import weka.classifiers.trees.RandomTree;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.PartitionGenerator;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomCommittee
extends RandomizableParallelIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler,
PartitionGenerator {
    static final long serialVersionUID = -9204394360557300093L;
    protected Instances m_data;

    public RandomCommittee() {
        this.m_Classifier = new RandomTree();
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.RandomTree";
    }

    public String globalInfo() {
        return "Class for building an ensemble of randomizable base classifiers. Each base classifiers is built using a different random number seed (but based one the same data). The final prediction is a straight average of the predictions generated by the individual base classifiers.";
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_data = new Instances(data);
        this.m_data.deleteWithMissingClass();
        super.buildClassifier(this.m_data);
        if (!(this.m_Classifier instanceof Randomizable)) {
            throw new IllegalArgumentException("Base learner must implement Randomizable!");
        }
        this.m_Classifiers = AbstractClassifier.makeCopies(this.m_Classifier, this.m_NumIterations);
        Random random = this.m_data.getRandomNumberGenerator(this.m_Seed);
        if (!(this.m_Classifier instanceof WeightedInstancesHandler)) {
            this.m_data = this.m_data.resampleWithWeights(random);
        }
        int j = 0;
        while (j < this.m_Classifiers.length) {
            ((Randomizable)((Object)this.m_Classifiers[j])).setSeed(random.nextInt());
            ++j;
        }
        this.buildClassifiers();
        this.m_data = null;
    }

    @Override
    protected synchronized Instances getTrainingSet(int iteration) throws Exception {
        return this.m_data;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] sums = new double[instance.numClasses()];
        int i = 0;
        while (i < this.m_NumIterations) {
            if (instance.classAttribute().isNumeric()) {
                sums[0] = sums[0] + this.m_Classifiers[i].classifyInstance(instance);
            } else {
                double[] newProbs = this.m_Classifiers[i].distributionForInstance(instance);
                int j = 0;
                while (j < newProbs.length) {
                    int n = j;
                    sums[n] = sums[n] + newProbs[j];
                    ++j;
                }
            }
            ++i;
        }
        if (instance.classAttribute().isNumeric()) {
            sums[0] = sums[0] / (double)this.m_NumIterations;
            return sums;
        }
        if (Utils.eq(Utils.sum(sums), 0.0)) {
            return sums;
        }
        Utils.normalize(sums);
        return sums;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "RandomCommittee: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("All the base classifiers: \n\n");
        int i = 0;
        while (i < this.m_Classifiers.length) {
            text.append(String.valueOf(this.m_Classifiers[i].toString()) + "\n\n");
            ++i;
        }
        return text.toString();
    }

    @Override
    public void generatePartition(Instances data) throws Exception {
        if (!(this.m_Classifier instanceof PartitionGenerator)) {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
        }
        this.buildClassifier(data);
    }

    @Override
    public double[] getMembershipValues(Instance inst) throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            ArrayList<double[]> al = new ArrayList<double[]>();
            int size = 0;
            int i = 0;
            while (i < this.m_Classifiers.length) {
                double[] r = ((PartitionGenerator)((Object)this.m_Classifiers[i])).getMembershipValues(inst);
                size += r.length;
                al.add(r);
                ++i;
            }
            double[] values = new double[size];
            int pos = 0;
            for (double[] v : al) {
                System.arraycopy(v, 0, values, pos, v.length);
                pos += v.length;
            }
            return values;
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public int numElements() throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            int size = 0;
            int i = 0;
            while (i < this.m_Classifiers.length) {
                size += ((PartitionGenerator)((Object)this.m_Classifiers[i])).numElements();
                ++i;
            }
            return size;
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9317 $");
    }

    public static void main(String[] argv) {
        RandomCommittee.runClassifier(new RandomCommittee(), argv);
    }
}

